 

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_PRECO_TBL_ATUALIZACAO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_PRECO_TBL_ATUALIZACAO]
GO
   
--EXECUTE P_EST_PROD_PRECO_TBL_ATUALIZACAO
CREATE PROCEDURE [dbo].[P_EST_PROD_PRECO_TBL_ATUALIZACAO] AS
	 
	
	DECLARE @CD_CTR_GRP INT
	DECLARE @CD_CTR  INT
	DECLARE @DT_REF DATETIME
	
	SET @DT_REF =  CONVERT(DATETIME, CONVERT(VARCHAR ,GETDATE(),112) );

	SET NOCOUNT ON
	
	DECLARE PrecoGrupo CURSOR FAST_FORWARD FOR 
	SELECT 
		CD_CTR_GRP,
		CD_CTR 
	FROM 
		EST_PROD_PRECO_TBL_HIST 
	WHERE 
		DT_PROCESSAR <=@DT_REF
		AND FLAG_PROCESSADO = 0 
	ORDER BY 1,2
	
	
	OPEN PrecoGrupo 
	FETCH NEXT FROM PrecoGrupo INTO @CD_CTR_GRP,@CD_CTR 

	WHILE @@FETCH_STATUS=0
		Begin
			
			PRINT 'Atualizando o grupo de preos ' + convert(varchar,@CD_CTR_GRP);
			
			EXECUTE P_EST_PROD_PRECO_TBL_ATUALIZACAO_GRUPO_PRECOS @CD_CTR_GRP, @CD_CTR; 
							
			FETCH NEXT FROM PrecoGrupo INTO @CD_CTR_GRP,@CD_CTR 
		End
	--Fechando cursor
	CLOSE PrecoGrupo;
	--Desalocando cursor da memoria
	DEALLOCATE PrecoGrupo;

GO


